PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144686658"
 Author = "jayas.jayas"
 Desc = "Parallel Transmission Lines using Protection Circuit"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,720,1170]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,720,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,720,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(44999416,"V2a",0,,,)
     Curve(44628104,"V2b",1,,,)
     Curve(44663184,"V2c",2,,,)
     }
    Graph([0,282],[0,0,720,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(44619440,"I2a",0,,,)
     Curve(44622272,"I2b",1,,,)
     Curve(44717496,"I2c",2,,,)
     }
    Graph([0,563],[0,0,720,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(44714720,"I20",0,,,)
     }
    PGraph([0,844],[0,0,720,263],"PolyGraph")
     {
     Options = 2
     Curve(44635008,"Br2a",0,,,1)
     Curve(44655064,"Br2b",1,,,1)
     Curve(44637648,"Br2c",2,,,1)
     }
    }
   -Plot-([810,18],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,720,1170]
    Posn = [810,18]
    Icon = [-1,-1]
    Extents = 0,0,720,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,720,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(44787144,"V4a",0,,,)
     Curve(44790056,"V4b",1,,,)
     Curve(44993600,"V4c",2,,,)
     }
    Graph([0,282],[0,0,720,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(44792968,"I4a",0,,,)
     Curve(44796056,"I4b",1,,,)
     Curve(44798832,"I4c",2,,,)
     }
    Graph([0,563],[0,0,720,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(44801744,"I40",0,,,)
     }
    PGraph([0,844],[0,0,720,263],"PolyGraph")
     {
     Options = 2
     Curve(44553944,"Br4a",0,,,1)
     Curve(44821832,"Br4b",1,,,1)
     Curve(44824608,"Br4c",2,,,1)
     }
    }
   }
  }
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144686326
  Nodes = 
   {
   Output("F",36,18)
    {
    Type = Integer
    }
   Output("B",36,-36)
    {
    Type = Integer
    Dim  = [5]
    }
   Input("Flt_en",36,-18)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Line(34,-18,27,-18)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   -Sticky-([72,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,666,180,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -Wire-([648,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([684,684],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([684,720],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([810,702],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1512,1134],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1512,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(44927224)
    Meter(44969696)
    Slider(44924312)
    Meter(44836960)
    Meter(44670712)
    Meter(44698384)
    Meter(44815952)
    Meter(44818920)
    }
   -Sticky-([522,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 522,108,684,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([522,216],1,0,-1)
    {
    }
   -ControlPanel-([72,720],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,504,126
    Dial(44848224)
    Dial(44876592)
    Slider(43951888)
    Slider(43954856)
    Slider(45003616)
    Switch(43945688)
    }
   0.datalabel([1656,720],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([1656,774],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([1656,828],3,0,-1)
    {
    Name = "B4T1"
    }
   -Sticky-([1386,954],0)
    {
    Name = ""
    Font = 1
    Bounds = 1386,954,1494,990
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   0.datalabel([1548,990],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1548,1008],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1548,1026],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1548,1044],6,0,-1)
    {
    Name = "B4"
    }
   -Sticky-([1386,162],0)
    {
    Name = ""
    Font = 1
    Bounds = 1386,162,1494,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Wire-([648,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([1386,396],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(43896896)
    Slider(43907992)
    Slider(43928352)
    }
   0.datalabel([1656,882],3,0,-1)
    {
    Name = "B4T2"
    }
   -ControlPanel-([1386,630],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(43948272)
    Slider(43920776)
    Slider(43850264)
    }
   -ControlPanel-([1386,774],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(43923544)
    Slider(43847408)
    Slider(43844256)
    }
   0.var([1620,882],0,43844256,150)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1620,828],0,43847408,130)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.37"
    Units = "s"
    Collect = "1"
    }
   0.var([1620,774],0,43850264,120)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.tfaultn([774,702],4,0,220)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Sticky-([18,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,198,144,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(44931088)
    Meter(44963872)
    Slider(44934128)
    Meter(44834048)
    Meter(44842816)
    Meter(44701392)
    Meter(44881752)
    Meter(44813152)
    }
   -Wire-([1980,468],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1980,288],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([2016,468],6,0,210)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([2016,288],0,0,260)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([2052,288],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([2052,252],0,43892888,10)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([2160,288],4,0,-1)
    {
    Name = "B1"
    }
   -Wire-([2052,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([2052,414],6,43896896,60)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([2088,432],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([2160,432],2,0,-1)
    {
    Name = "B2"
    }
   0.tbreakn([1926,288],4,0,180)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.tbreakn([1926,468],4,0,200)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   0.datalabel([1656,342],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([1656,396],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1656,450],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([1620,396],0,43905272,40)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1620,450],0,43907992,50)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1656,504],3,0,-1)
    {
    Name = "B2T2"
    }
   0.var([1620,342],0,43911632,20)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([1530,162],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1530,162,1692,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.logic([2124,288],6,0,270)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([1998,882],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1998,702],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1998,738],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([1962,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2070,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2070,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,846],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([2178,702],4,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([2178,846],2,0,-1)
    {
    Name = "B4"
    }
   0.var([1620,720],0,43920776,110)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.36"
    Units = "s"
    Collect = "1"
    }
   0.var_switch([2070,828],6,43923544,140)
    {
    Name = "42-B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.logic([2142,846],0,0,310)
    {
    Type = "2"
    Inv = "0"
    }
   0.tbreakn([1944,882],4,0,160)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.var([1620,504],0,43928352,70)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.tbreakn([1944,702],4,0,230)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   0.logic([2124,432],0,0,280)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([1962,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.export([1602,1134],4,0,330)
    {
    Name = "F"
    }
   0.export([1602,1098],4,0,340)
    {
    Name = "B"
    }
   -Wire-([1494,1062],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datamerge([1566,1062],4,0,320)
    {
    N = "5"
    Type = "1"
    Disp = "1"
    }
   0.logic([2034,702],0,0,290)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1944,792],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.logic([1908,792],0,0,240)
    {
    Type = "1"
    Inv = "0"
    }
   0.datalabel([1872,828],0,0,-1)
    {
    Name = "enable"
    }
   -Wire-([1980,324],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([1944,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1872,414],0,0,-1)
    {
    Name = "enable"
    }
   0.logic([1908,378],0,0,190)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([2034,882],6,0,250)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1800,378],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1800,792],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1800,378],0,0,-1)
    {
    Vertex="0,0;0,414"
    }
   0.import([1764,378],0,0,30)
    {
    Name = "Flt_en"
    }
   0.datalabel([1512,1062],0,0,-1)
    {
    Name = "enable"
    }
   0.var_switch([1458,1062],0,43945688,170)
    {
    Name = "Enable"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "Time"
    Toff = "Prot"
    }
   0.var_switch([2070,666],0,43948272,100)
    {
    Name = "42-B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.logic([2142,702],6,0,300)
    {
    Type = "2"
    Inv = "0"
    }
   0.var([612,684],0,43951888,80)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.var([612,720],0,43954856,90)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.1"
    Units = ""
    Collect = "1"
    }
   -Sticky-([72,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,864,234,1170
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source
          and  B1
  2=> FT2: 
          Between B1 
          and Line
  3=> FT3: 
          Between Line 1
          and B2
  4=> FT4: 
          Between Source
          and B2
  5=> FT5:
          Between B3
          and Line 2
  6=> FT6:
          Between Line 2 
          and B4 "
    }
   -Sticky-([396,864],0)
    {
    Name = ""
    Font = 1
    Bounds = 396,864,684,1008
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Protection is turned on and off using a button in the 
protection sub pages, found on the main page.
Breakers B1 through B4 are controlled  by  protection 
sub pages found  on  main page.
Using the Protection circuitry, Breaker B3 open after 
the fault is detected, and uses a set
amount of time to open, modelling a physical breaker."
    }
   -Sticky-([252,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 252,864,378,1080
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> no fault
11=> No fault (0)"
    }
   -ControlPanel-([1386,252],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(43892888)
    Slider(43911632)
    Slider(43905272)
    }
   -Sticky-([990,144],0)
    {
    Name = ""
    Font = 1
    Bounds = 990,144,1116,180
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "COMTRADE Recorders"
    }
   -ControlPanel-([918,342],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,288,126
    Switch(45055392)
    Switch(45047232)
    Switch(45049952)
    Switch(45052672)
    }
   -Sticky-([936,486],0)
    {
    Name = ""
    Font = 1
    Bounds = 936,486,1188,576
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn on or off each recorder individually."
    }
   -ControlPanel-([990,198],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(45039048)
    Slider(45032448)
    }
   -Divider-([18,594],0)
    {
    Size(1296,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1314,90],0)
    {
    Size(0,1458)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1296,936],0)
    {
    Size(1098,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([792,90],0)
    {
    Size(0,504)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,738,1170]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(44831080,"V1a",0,,,)
     Curve(44641320,"V1b",1,,,)
     Curve(44625184,"V1c",2,,,)
     }
    Graph([0,282],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(44704304,"I1a",0,,,)
     Curve(44720576,"I1b",1,,,)
     Curve(44707136,"I1c",2,,,)
     }
    Graph([0,563],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(44710888,"I10",0,,,)
     }
    PGraph([0,844],[0,0,738,263],"PolyGraph")
     {
     Options = 2
     Curve(44996640,"Br1a",0,,,1)
     Curve(44644096,"Br1b",1,,,1)
     Curve(44693392,"Br1c",2,,,1)
     }
    }
   -Plot-([792,18],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,738,1170]
    Posn = [792,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(44766728,"V3a",0,,,)
     Curve(44769504,"V3b",1,,,)
     Curve(44772416,"V3c",2,,,)
     }
    Graph([0,282],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(44775328,"I3a",0,,,)
     Curve(44778240,"I3b",1,,,)
     Curve(44781152,"I3c",2,,,)
     }
    Graph([0,563],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(44784232,"I30",0,,,)
     }
    PGraph([0,844],[0,0,738,263],"PolyGraph")
     {
     Options = 2
     Curve(44804656,"Br3a",0,,,1)
     Curve(44807432,"Br3b",1,,,1)
     Curve(44810208,"Br3c",2,,,1)
     }
    }
   }
  }
 Module("Prot_4")
  {
  Desc = ""
  FileDate = 1144686326
  Nodes = 
   {
   Input("En",-18,-54)
    {
    Type = Integer
    }
   Input("Bx",18,-54)
    {
    Type = Integer
    }
   Input("V",-54,-18)
    {
    Type = Real
    Dim  = [3]
    }
   Input("I",-54,18)
    {
    Type = Real
    Dim  = [4]
    }
   Output("B",54,0)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-29,-29,29,29)
   Text(0,-7,"Protection")
   Pen(ByNode,ByNode,ByNode,En)
   Line(-18,-54,-18,-29)
   Pen(,Solid)
   Line(-18,-29,-24,-35)
   Line(-18,-29,-11,-35)
   Pen(,ByNode,,Bx)
   Line(18,-54,18,-29)
   Pen(,Solid)
   Line(18,-29,11,-35)
   Line(18,-29,24,-35)
   Pen(,ByNode,,V)
   Line(-54,-18,-29,-18)
   Pen(,Solid)
   Line(-29,-18,-35,-11)
   Line(-29,-18,-35,-24)
   Pen(,ByNode,,I)
   Line(-54,18,-29,18)
   Pen(,Solid)
   Line(-29,18,-35,24)
   Line(-29,18,-35,11)
   Pen(,ByNode,,B)
   Line(54,0,29,0)
   Text(0,4,"B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Wire-([576,252],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   -Wire-([774,252],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   -Wire-([846,594],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.logic([954,396],0,0,210)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1260,162],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.const([684,144],0,0,20)
    {
    Name = ""
    Value = ".1"
    }
   0.time-sig([684,108],0,0,10)
    {
    }
   -Wire-([792,108],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([918,108],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([1350,342],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1296,342],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.logic([1386,360],0,0,240)
    {
    Type = "2"
    Inv = "0"
    }
   0.compar([720,108],0,0,150)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([990,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.inv([1098,324],0,0,90)
    {
    INTR = "0"
    }
   0.logic([1170,360],6,0,230)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1098,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1134,360],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1206,360],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1206,396],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.pgb([1206,378],0,44266320,290)
    {
    Name = "<Untitled>"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.logic([882,432],0,0,200)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([576,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([576,594],0,0,-1)
    {
    Vertex="0,0;270,0"
    }
   -Wire-([1080,324],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1296,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.export([1458,360],2,0,280)
    {
    Name = "B"
    }
   -ControlPanel-([1026,90],0)
    {
    Name = "Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Slider(44286336)
    }
   -Sticky-([378,774],0)
    {
    Name = ""
    Font = 1
    Bounds = 378,774,630,900
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Positive sequence impedance of Tline
   R = 14.5536 ohm
   X = 78.1537 ohm

Z = 79.5 / 80 deg.

Set  protection  to be 85% or  67 ohm @ 80 deg.

Station 2 set to over reach by 7%, ie 85 ohm."
    }
   0.import([1260,342],0,0,100)
    {
    Name = "Bx"
    }
   -Wire-([1206,162],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([576,288],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var([1170,162],0,44286336,40)
    {
    Name = "B4opT"
    Group = ""
    Display = "0"
    Max = ".1"
    Min = "0.0"
    Value = "0.05"
    Units = ""
    Collect = "1"
    }
   0.datalabel([1260,162],0,0,-1)
    {
    Name = "B4opT"
    }
   0.import([1044,324],0,0,80)
    {
    Name = "En"
    }
   0.pgb([612,630],1,44291152,250)
    {
    Name = "B4Testc"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([612,594],3,44293792,260)
    {
    Name = "B4cprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([612,468],1,44296568,270)
    {
    Name = "B4Test"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([612,288],1,44299344,310)
    {
    Name = "B4Test"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([612,252],3,44302120,320)
    {
    Name = "B4aprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.logic([810,432],6,0,180)
    {
    Type = "2"
    Inv = "0"
    }
   0.bin_delay([1062,396],0,0,220)
    {
    T = "B4opT"
    Toff = "1.00 [s]"
    INITST = "0"
    INTR = "0"
    }
   -Sticky-([990,468],0)
    {
    Name = ""
    Font = 1
    Bounds = 990,468,1278,504
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "The On delay timer represents the breaker operating time"
    }
   0.datatap([468,252],0,0,50)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([468,288],0,0,70)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([414,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([468,432],0,0,110)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([468,468],0,0,120)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([414,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([468,594],0,0,130)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([468,630],0,0,140)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.import([306,234],0,0,30)
    {
    Name = "V"
    }
   -Wire-([342,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([342,270],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([378,576],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([378,414],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([378,234],0,0,-1)
    {
    Vertex="0,0;0,342"
    }
   -Wire-([414,270],0,0,-1)
    {
    Vertex="0,0;0,342"
    }
   0.import([306,270],0,0,60)
    {
    Name = "I"
    }
   0.pgb([612,432],3,44318760,300)
    {
    Name = "B4bprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([576,432],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   -Wire-([576,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.block_avg([504,252],0,0,160)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "45 [ohm]"
    Ph = "86 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   0.block_avg([504,432],0,0,170)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "45 [ohm]"
    Ph = "86 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   0.block_avg([504,594],0,0,190)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "45 [ohm]"
    Ph = "86 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   }
  }
 Module("prot_2")
  {
  Desc = ""
  FileDate = 1144686326
  Nodes = 
   {
   Input("EN",-18,-54)
    {
    Type = Integer
    }
   Input("Bx",18,-54)
    {
    Type = Real
    }
   Input("V",-54,-18)
    {
    Type = Real
    Dim  = [3]
    }
   Input("I",-54,18)
    {
    Type = Real
    Dim  = [4]
    }
   Output("B",54,0)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-29,-29,29,29)
   Text(0,-7,"Protection ")
   Pen(ByNode,ByNode,ByNode,EN)
   Line(-18,-54,-18,-29)
   Pen(,Solid)
   Line(-18,-29,-24,-35)
   Line(-18,-29,-11,-35)
   Pen(,ByNode,,Bx)
   Line(18,-54,18,-29)
   Pen(,Solid)
   Line(18,-29,11,-35)
   Line(18,-29,24,-35)
   Pen(,ByNode,,V)
   Line(-54,-18,-29,-18)
   Pen(,Solid)
   Line(-29,-18,-35,-11)
   Line(-29,-18,-35,-24)
   Pen(,ByNode,,I)
   Line(-54,18,-29,18)
   Pen(,Solid)
   Line(-29,18,-35,24)
   Line(-29,18,-35,11)
   Pen(,ByNode,,B)
   Line(54,0,29,0)
   Text(0,4,"B2")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Wire-([576,252],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   -Wire-([774,252],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   -Wire-([846,594],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.logic([954,396],0,0,210)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1260,162],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.const([684,144],0,0,20)
    {
    Name = ""
    Value = ".1"
    }
   0.time-sig([684,108],0,0,10)
    {
    }
   -Wire-([792,108],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([918,108],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([1350,342],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1296,342],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.logic([1386,360],0,0,240)
    {
    Type = "2"
    Inv = "0"
    }
   0.compar([720,108],0,0,150)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([990,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.inv([1098,324],0,0,90)
    {
    INTR = "0"
    }
   0.logic([1170,360],6,0,230)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1098,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1134,360],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1206,360],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1206,396],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.pgb([1206,378],0,44341360,290)
    {
    Name = "<Untitled>"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.logic([882,432],0,0,200)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([576,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([576,594],0,0,-1)
    {
    Vertex="0,0;270,0"
    }
   0.block_avg([504,252],0,0,160)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "67 [ohm]"
    Ph = "80 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   0.block_avg([504,594],0,0,190)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "67 [ohm]"
    Ph = "80 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   -Wire-([1080,324],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1296,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.export([1458,360],2,0,280)
    {
    Name = "B"
    }
   -ControlPanel-([1026,90],0)
    {
    Name = "Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Slider(44365128)
    }
   0.logic([810,432],6,0,180)
    {
    Type = "2"
    Inv = "0"
    }
   -Sticky-([414,720],0)
    {
    Name = ""
    Font = 1
    Bounds = 414,720,666,846
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Positive sequence impedance of Tline
   R = 14.5536 ohm
   X = 78.1537 ohm

Z = 79.5 / 80 deg.

Set  protection  to be 85% or  67 ohm @ 80 deg.

Station 2 set to over reach by 7%, ie 85 ohm."
    }
   0.import([1260,342],0,0,100)
    {
    Name = "Bx"
    }
   -Wire-([1206,162],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1260,162],0,0,-1)
    {
    Name = "B2opT"
    }
   0.var([1170,162],0,44365128,40)
    {
    Name = "B2opT"
    Group = ""
    Display = "0"
    Max = ".1"
    Min = "0.0"
    Value = "0.05"
    Units = ""
    Collect = "1"
    }
   -Wire-([576,288],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([612,252],3,44368176,320)
    {
    Name = "B2aprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([612,288],1,44371080,310)
    {
    Name = "B2Test"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([612,432],3,44373856,300)
    {
    Name = "B2bprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([612,468],1,44376632,270)
    {
    Name = "B2Test"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([612,594],3,44379576,260)
    {
    Name = "B2cprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([612,630],1,44382352,250)
    {
    Name = "B2Testc"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.import([1044,324],0,0,80)
    {
    Name = "En"
    }
   0.bin_delay([1062,396],0,0,220)
    {
    T = "B2opT"
    Toff = "1.00 [s]"
    INITST = "0"
    INTR = "0"
    }
   -Wire-([576,432],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   0.block_avg([504,432],0,0,170)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "67 [ohm]"
    Ph = "80 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   -Wire-([576,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([468,252],0,0,50)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([468,288],0,0,70)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([414,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([468,432],0,0,110)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([468,468],0,0,120)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([414,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([468,594],0,0,130)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([468,630],0,0,140)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.import([306,234],0,0,30)
    {
    Name = "V"
    }
   -Wire-([342,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([342,270],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([378,576],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([378,414],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([378,234],0,0,-1)
    {
    Vertex="0,0;0,342"
    }
   -Wire-([414,270],0,0,-1)
    {
    Vertex="0,0;0,342"
    }
   0.import([306,270],0,0,60)
    {
    Name = "I"
    }
   }
  }
 Module("Prot_3")
  {
  Desc = ""
  FileDate = 1144686326
  Nodes = 
   {
   Input("En",-18,-54)
    {
    Type = Integer
    }
   Input("Bx",18,-54)
    {
    Type = Real
    }
   Input("V",-54,-18)
    {
    Type = Real
    Dim  = [3]
    }
   Input("I",-54,18)
    {
    Type = Real
    Dim  = [4]
    }
   Output("B",54,0)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-29,-29,29,29)
   Text(0,-7,"Protection ")
   Pen(ByNode,ByNode,ByNode,En)
   Line(-18,-54,-18,-29)
   Pen(,Solid)
   Line(-18,-29,-24,-35)
   Line(-18,-29,-11,-35)
   Pen(,ByNode,,Bx)
   Line(18,-54,18,-29)
   Pen(,Solid)
   Line(18,-29,11,-35)
   Line(18,-29,24,-35)
   Pen(,ByNode,,V)
   Line(-54,-18,-29,-18)
   Pen(,Solid)
   Line(-29,-18,-35,-11)
   Line(-29,-18,-35,-24)
   Pen(,ByNode,,I)
   Line(-54,18,-29,18)
   Pen(,Solid)
   Line(-29,18,-35,24)
   Line(-29,18,-35,11)
   Pen(,ByNode,,B)
   Line(54,0,29,0)
   Text(0,4,"B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Wire-([576,252],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   -Wire-([774,252],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   -Wire-([846,594],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.logic([954,396],0,0,210)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1260,162],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.const([684,144],0,0,20)
    {
    Name = ""
    Value = ".1"
    }
   0.time-sig([684,108],0,0,10)
    {
    }
   -Wire-([792,108],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([918,108],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([1350,342],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1296,342],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.logic([1386,360],0,0,240)
    {
    Type = "2"
    Inv = "0"
    }
   0.compar([720,108],0,0,150)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([990,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.inv([1098,324],0,0,90)
    {
    INTR = "0"
    }
   0.logic([1170,360],6,0,230)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1098,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1134,360],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1206,360],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1206,396],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.pgb([1206,378],0,44415568,290)
    {
    Name = "<Untitled>"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.logic([882,432],0,0,200)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([576,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([576,594],0,0,-1)
    {
    Vertex="0,0;270,0"
    }
   -Wire-([1080,324],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1296,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.export([1458,360],2,0,280)
    {
    Name = "B"
    }
   -ControlPanel-([1026,90],0)
    {
    Name = "Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Slider(44453160)
    }
   0.logic([810,432],6,0,180)
    {
    Type = "2"
    Inv = "0"
    }
   -Sticky-([378,774],0)
    {
    Name = ""
    Font = 1
    Bounds = 378,774,630,900
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Positive sequence impedance of Tline
   R = 14.5536 ohm
   X = 78.1537 ohm

Z = 79.5 / 80 deg.

Set  protection  to be 85% or  67 ohm @ 80 deg.

Station 2 set to over reach by 7%, ie 85 ohm."
    }
   0.import([1260,342],0,0,100)
    {
    Name = "Bx"
    }
   -Wire-([1206,162],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([576,288],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([612,252],3,44436688,320)
    {
    Name = "B2aprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([612,288],1,44439464,310)
    {
    Name = "B2Test"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([612,432],3,44442184,300)
    {
    Name = "B2bprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([612,468],1,44444960,270)
    {
    Name = "B2Test"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([612,594],3,44447744,260)
    {
    Name = "B2cprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([612,630],1,44450384,250)
    {
    Name = "B2Testc"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.var([1170,162],0,44453160,40)
    {
    Name = "B3opT"
    Group = ""
    Display = "0"
    Max = ".1"
    Min = "0.0"
    Value = "0.05"
    Units = ""
    Collect = "1"
    }
   0.datalabel([1260,162],0,0,-1)
    {
    Name = "B3opT"
    }
   0.import([1044,324],0,0,80)
    {
    Name = "En"
    }
   0.datatap([468,252],0,0,50)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([468,288],0,0,70)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([414,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([468,432],0,0,110)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([468,468],0,0,120)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([414,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([468,594],0,0,130)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([468,630],0,0,140)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.import([306,234],0,0,30)
    {
    Name = "V"
    }
   -Wire-([342,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([342,270],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([378,576],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([378,414],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([378,234],0,0,-1)
    {
    Vertex="0,0;0,342"
    }
   -Wire-([414,270],0,0,-1)
    {
    Vertex="0,0;0,342"
    }
   0.import([306,270],0,0,60)
    {
    Name = "I"
    }
   -Wire-([576,432],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   -Wire-([576,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.block_avg([504,594],0,0,190)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "45 [ohm]"
    Ph = "86 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   0.block_avg([504,432],0,0,170)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "45 [ohm]"
    Ph = "86 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   0.bin_delay([1062,396],0,0,220)
    {
    T = "B3opT"
    Toff = "1.00 [s]"
    INITST = "0"
    INTR = "0"
    }
   0.block_avg([504,252],0,0,160)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "45 [ohm]"
    Ph = "86 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   }
  }
 Module("Prot_1")
  {
  Desc = ""
  FileDate = 1144686327
  Nodes = 
   {
   Input("EN",-18,-54)
    {
    Type = Integer
    }
   Input("Bx",18,-54)
    {
    Type = Integer
    }
   Input("V",-54,-18)
    {
    Type = Real
    Dim  = [3]
    }
   Input("I",-54,18)
    {
    Type = Real
    Dim  = [4]
    }
   Output("out",54,0)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-29,-29,29,29)
   Text(0,-7,"Protection")
   Pen(ByNode,ByNode,ByNode,EN)
   Line(-18,-54,-18,-29)
   Pen(,Solid)
   Line(-18,-29,-24,-35)
   Line(-18,-29,-11,-35)
   Pen(,ByNode,,Bx)
   Line(18,-54,18,-29)
   Pen(,Solid)
   Line(18,-29,11,-35)
   Line(18,-29,24,-35)
   Pen(,ByNode,,V)
   Line(-54,-18,-29,-18)
   Pen(,Solid)
   Line(-29,-18,-35,-11)
   Line(-29,-18,-35,-24)
   Pen(,ByNode,,I)
   Line(-54,18,-29,18)
   Pen(,Solid)
   Line(-29,18,-35,24)
   Line(-29,18,-35,11)
   Pen(,ByNode,,out)
   Line(54,0,29,0)
   Text(0,4,"B1")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   0.pgb([450,252],3,44477736,320)
    {
    Name = "B1aprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([432,288],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([450,288],1,44481512,310)
    {
    Name = "B1Test"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([432,468],1,44484416,270)
    {
    Name = "B1Test"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([504,288],0,0,-1)
    {
    Name = "B1testa"
    }
   0.pgb([450,594],3,44488088,260)
    {
    Name = "B1cprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([450,432],3,44490728,300)
    {
    Name = "B1bprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([432,252],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   -Wire-([630,252],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   -Wire-([702,594],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.logic([810,396],0,0,210)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1116,162],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.const([540,144],0,0,20)
    {
    Name = ""
    Value = ".1"
    }
   0.time-sig([540,108],0,0,10)
    {
    }
   -Wire-([648,108],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([774,108],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([1206,342],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1152,342],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1116,162],0,0,-1)
    {
    Name = "B1opT"
    }
   0.logic([1242,360],0,0,240)
    {
    Type = "2"
    Inv = "0"
    }
   0.compar([576,108],0,0,150)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([846,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.inv([954,324],0,0,90)
    {
    INTR = "0"
    }
   0.logic([1026,360],6,0,230)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([954,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([990,360],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1062,360],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1062,396],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.pgb([1062,378],0,44505864,290)
    {
    Name = "<Untitled>"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.logic([738,432],0,0,200)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([468,630],0,0,-1)
    {
    Name = "B1testc"
    }
   -Wire-([432,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([432,594],0,0,-1)
    {
    Vertex="0,0;270,0"
    }
   0.pgb([432,630],1,44511336,250)
    {
    Name = "B1Testc"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([936,324],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1152,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -ControlPanel-([882,90],0)
    {
    Name = "Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Slider(44528944)
    }
   0.logic([666,432],6,0,180)
    {
    Type = "2"
    Inv = "0"
    }
   -Sticky-([288,684],0)
    {
    Name = ""
    Font = 1
    Bounds = 288,684,540,810
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Positive sequence impedance of Tline
   R = 14.5536 ohm
   X = 78.1537 ohm

Z = 79.5 / 80 deg.

Set  protection  to be 85% or  67 ohm @ 80 deg.

Station 2 set to over reach by 7%, ie 85 ohm."
    }
   0.import([1116,342],0,0,100)
    {
    Name = "Bx"
    }
   -Wire-([1062,162],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var([1026,162],0,44528944,40)
    {
    Name = "B1opT"
    Group = ""
    Display = "0"
    Max = ".1"
    Min = "0.0"
    Value = "0.05"
    Units = ""
    Collect = "1"
    }
   0.export([1314,360],2,0,280)
    {
    Name = "out"
    }
   0.bin_delay([918,396],0,0,220)
    {
    T = "B1opT"
    Toff = "1.00 [s]"
    INITST = "0"
    INTR = "0"
    }
   0.datatap([324,252],0,0,50)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([324,288],0,0,70)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([270,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([324,432],0,0,110)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([324,468],0,0,120)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([270,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([324,594],0,0,130)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([324,630],0,0,140)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([198,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([198,270],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([234,576],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([234,414],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([234,234],0,0,-1)
    {
    Vertex="0,0;0,342"
    }
   -Wire-([270,270],0,0,-1)
    {
    Vertex="0,0;0,342"
    }
   0.import([162,270],0,0,60)
    {
    Name = "I"
    }
   0.import([162,234],0,0,30)
    {
    Name = "V"
    }
   -Wire-([432,432],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   -Wire-([432,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([468,468],0,0,-1)
    {
    Name = "B1testb"
    }
   0.block_avg([360,432],0,0,170)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "45 [ohm]"
    Ph = "86 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   0.block_avg([360,594],0,0,190)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "45 [ohm]"
    Ph = "86 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   0.import([900,324],0,0,80)
    {
    Name = "En"
    }
   0.block_avg([360,252],0,0,160)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "45 [ohm]"
    Ph = "86 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144686326
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.pgb([2250,1242],0,44553944,1200)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([468,1170],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([504,1170],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([540,1170],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([468,1350],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([504,1350],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([540,1350],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1818,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1836,1242],0,0,290)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1836,1278],0,0,390)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([360,1170],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([396,1170],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([432,1170],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([360,1350],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([396,1350],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([432,1350],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([2214,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2214,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2214,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2214,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1980,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1980,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1980,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1854,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1854,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1854,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1962,1314],0,0,490)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1962,1278],0,0,420)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1962,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1962,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1962,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1836,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1836,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1836,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1836,1314],0,0,460)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1962,1242],0,0,320)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1944,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1044,1278],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([1080,1278],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([1116,1278],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([1098,1368],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([1044,1530],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([1080,1530],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([1116,1530],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([1134,1440],2,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1998,522],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1980,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1854,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([810,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([414,504],0,0,-1)
    {
    Vertex="0,0;0,252"
    }
   -Wire-([342,630],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([360,738],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([360,756],0,0,-1)
    {
    Name = "F1"
    }
   -Wire-([954,504],0,0,-1)
    {
    Vertex="0,0;0,252"
    }
   0.pgb([2376,1314],0,44593944,540)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([2376,1350],0,44596472,550)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([792,540],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([792,558],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([792,774],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([792,792],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([1188,1278],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([1224,1530],0,0,-1)
    {
    Name = "F6"
    }
   0.breaker3([918,522],0,0,680)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "1.04 [MW]"
    Q = "-18.63 [MVAR]"
    }
   0.datalabel([576,540],0,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([576,558],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([576,774],0,0,-1)
    {
    Name = "FT5"
    }
   -Wire-([558,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.breaker3([450,522],4,0,660)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "-0.0002565 [MW]"
    Q = "0.01616 [MVAR]"
    }
   -Wire-([522,522],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([684,1422],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([702,1458],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([306,1458],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([702,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1332,1368],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([1332,1404],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([1332,1440],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1458,1368],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1458,1404],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1494,1368],0,44619440,1130)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1494,1404],0,44622272,1070)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1368,1314],0,44625184,370)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1494,1278],0,44628104,300)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datalabel([1584,1242],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1584,1278],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1584,1314],0,0,-1)
    {
    Name = "Br1C"
    }
   0.datalabel([1710,1242],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1710,1278],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1746,1242],0,44635008,1260)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1746,1314],0,44637648,1180)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1584,1368],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([1368,1278],0,44641320,260)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1620,1278],0,44644096,1250)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1746,1278],0,44655064,1230)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1314,1242],0,0,190)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1314,1278],0,0,250)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1296,1206],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([1332,1242],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([1332,1278],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1458,1278],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([1494,1314],0,44663184,400)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   -Wire-([1584,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1584,1440],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1584,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1584,1476],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1710,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1710,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1710,1476],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1458,1242],2,0,-1)
    {
    Name = "V2A"
    }
   0.pgb([1746,1368],0,44670712,1080)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.datalabel([1710,1440],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1710,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1710,1404],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1710,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1710,1368],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1710,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1710,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1710,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1710,1314],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1458,1440],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1458,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1458,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1458,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1332,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1332,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1332,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1458,1314],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1440,1314],0,0,380)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1440,1278],0,0,280)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1440,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1440,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1440,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1332,1314],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([1314,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1314,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1314,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1314,1314],0,0,350)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1584,1404],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1620,1314],0,44693392,1190)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datatap([1440,1242],0,0,220)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1422,1206],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([1422,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1746,1404],0,44698384,1020)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1620,1404],0,44701392,1050)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1368,1368],0,44704304,1140)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "1.5"
    }
   0.pgb([1368,1440],0,44707136,1030)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "1.5"
    }
   -Wire-([1458,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1332,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1368,1476],0,44710888,950)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "0.3"
    }
   0.datalabel([1458,1476],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1494,1476],0,44714720,920)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.3"
    Max = "0.5"
    }
   0.pgb([1494,1440],0,44717496,1000)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1368,1404],0,44720576,1090)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "1.5"
    }
   -Wire-([1296,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1332,1476],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1818,1206],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1854,1242],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1854,1278],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1854,1314],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1980,1242],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([1980,1278],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([1980,1314],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([756,1170],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([792,1170],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([828,1170],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([756,1350],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([792,1350],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([828,1350],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1854,1368],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1854,1404],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1854,1440],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1854,1476],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([1980,1368],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([1980,1404],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1980,1440],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([1980,1476],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([864,1170],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([900,1170],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([936,1170],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([864,1350],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([900,1350],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([936,1350],2,0,-1)
    {
    Name = "I4C"
    }
   0.recorder2_0([432,1242],0,0,1350)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([540,1314],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([540,1494],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2088,1368],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([2088,1404],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([2088,1242],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([2088,1278],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([2088,1314],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([2214,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2214,1242],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([2214,1278],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([2214,1314],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([2214,1368],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([2214,1404],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([1890,1242],0,44766728,310)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1890,1278],0,44769504,410)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1890,1314],0,44772416,470)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1890,1368],0,44775328,1060)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1890,1404],0,44778240,980)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1890,1440],0,44781152,910)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1890,1476],0,44784232,800)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "3.0"
    }
   0.pgb([2016,1242],0,44787144,330)
    {
    Name = "V4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([2016,1278],0,44790056,430)
    {
    Name = "V4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([2016,1368],0,44792968,1040)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([2016,1404],0,44796056,960)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([2016,1440],0,44798832,850)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([2016,1476],0,44801744,790)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "0.5"
    }
   0.pgb([2124,1242],0,44804656,1220)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2124,1278],0,44807432,1170)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2124,1314],0,44810208,1120)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2124,1404],0,44813152,930)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2250,1368],0,44815952,990)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([2250,1404],0,44818920,900)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2250,1278],0,44821832,1160)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2250,1314],0,44824608,1100)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([576,792],0,0,-1)
    {
    Name = "F5"
    }
   0.breaker3([450,738],4,0,700)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "-0.001192 [MW]"
    Q = "0.03199 [MVAR]"
    }
   0.pgb([1368,1242],0,44831080,210)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([2376,1242],0,44834048,440)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([2376,1278],0,44836960,510)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([414,630],0,0,-1)
    {
    Vertex="0,0;-144,0"
    }
   -Wire-([954,630],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datalabel([990,756],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([990,738],0,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([1008,630],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1620,1368],0,44842816,1110)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Wire-([306,1278],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([1998,468],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.datalabel([1944,468],4,0,-1)
    {
    Name = "Breaker"
    }
   0.datalabel([1062,1206],0,0,-1)
    {
    Name = "Breaker"
    }
   0.var_pot([1026,1404],0,44848224,480)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "6"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([1098,1404],0,0,500)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([1944,1206],2,0,-1)
    {
    Name = "V4"
    }
   0.mux_array([1116,1476],6,0,780)
    {
    DPath = "0"
    }
   0.datatap([1098,1188],6,0,610)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1044,1278],6,0,1330)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1080,1278],6,0,1320)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1116,1278],6,0,1310)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1152,1278],6,0,1300)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1188,1278],6,0,1290)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1224,1278],6,0,1280)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1152,1278],2,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([1206,1296],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datatap([1044,1530],0,0,890)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1080,1530],0,0,870)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1116,1530],0,0,860)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1152,1530],0,0,840)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1188,1530],0,0,830)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1224,1530],0,0,810)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1224,1278],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([1188,1530],0,0,-1)
    {
    Name = "F5"
    }
   -Wire-([1206,1512],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datalabel([1152,1530],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([1944,486],4,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([1944,486],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.breaker3([918,738],0,0,720)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "1.041 [MW]"
    Q = "-18.62 [MVAR]"
    }
   0.var_pot([1206,1404],2,44876592,530)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "1"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.unity([1134,1404],4,0,590)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([1134,1404],1,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([1134,1368],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.pgb([2124,1368],0,44881752,1010)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.datalabel([1386,1134],0,0,-1)
    {
    Name = "I1"
    }
   0.datalabel([1944,522],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1206,1188],2,0,-1)
    {
    Name = "B4x"
    }
   0.datalabel([1170,1188],2,0,-1)
    {
    Name = "B3x"
    }
   0.datalabel([1134,1188],2,0,-1)
    {
    Name = "B2x"
    }
   0.datalabel([1098,1188],2,0,-1)
    {
    Name = "B1x"
    }
   0.datatap([1206,1188],6,0,640)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1134,1188],6,0,620)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1170,1188],6,0,630)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1242,1188],2,0,-1)
    {
    Name = "Enable"
    }
   0.datatap([1242,1188],6,0,650)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1242,1206],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datalabel([1818,666],0,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([1818,702],0,0,-1)
    {
    Name = "I1"
    }
   0.datalabel([1854,630],2,0,-1)
    {
    Name = "Enable"
    }
   0.datalabel([1890,630],2,0,-1)
    {
    Name = "B1x"
    }
   0.datalabel([1926,684],0,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1854,756],2,0,-1)
    {
    Name = "Enable"
    }
   0.datalabel([1890,756],2,0,-1)
    {
    Name = "B2x"
    }
   0.datalabel([1818,792],0,0,-1)
    {
    Name = "V2"
    }
   0.datalabel([1818,828],0,0,-1)
    {
    Name = "I2"
    }
   0.datalabel([1926,810],0,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([2034,630],2,0,-1)
    {
    Name = "Enable"
    }
   0.datalabel([2070,630],2,0,-1)
    {
    Name = "B3x"
    }
   0.datalabel([1998,666],0,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1998,702],0,0,-1)
    {
    Name = "I3"
    }
   0.datalabel([2106,684],0,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([2034,756],2,0,-1)
    {
    Name = "Enable"
    }
   0.datalabel([2106,810],0,0,-1)
    {
    Name = "B4"
    }
   0.datalabel([2070,756],2,0,-1)
    {
    Name = "B4x"
    }
   0.datalabel([1998,828],0,0,-1)
    {
    Name = "I4"
    }
   0.datalabel([1998,792],0,0,-1)
    {
    Name = "V4"
    }
   -Wire-([1440,1116],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([1458,1116],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datamerge([1404,1134],5,0,670)
    {
    N = "4"
    Type = "2"
    Disp = "1"
    }
   0.datamerge([1566,1134],5,0,690)
    {
    N = "4"
    Type = "2"
    Disp = "1"
    }
   -Wire-([1620,1116],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1602,1116],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([1764,1116],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1746,1116],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datamerge([1710,1134],5,0,710)
    {
    N = "4"
    Type = "2"
    Disp = "1"
    }
   -Wire-([1908,1116],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datamerge([1854,1134],5,0,730)
    {
    N = "4"
    Type = "2"
    Disp = "1"
    }
   0.datalabel([1836,1134],0,0,-1)
    {
    Name = "I4"
    }
   0.datalabel([1692,1134],0,0,-1)
    {
    Name = "I3"
    }
   0.datalabel([1548,1134],0,0,-1)
    {
    Name = "I2"
    }
   -Wire-([1890,1116],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.var([1134,702],5,44924312,90)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1080,702],5,44927224,80)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   -Sticky-([216,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 216,504,306,540
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   0.var([252,702],3,44931088,60)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([198,702],3,44934128,50)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.source3R([234,630],6,0,560)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.source3R([1098,630],2,0,570)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Wire-([1080,1116],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1152,1116],0,0,-1)
    {
    Name = "Ron"
    }
   0.tpflt([324,720],0,0,1390)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([540,522],0,0,1410)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1026,720],4,0,1370)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([540,756],0,0,1380)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([828,756],4,0,1360)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.recorder2_0([828,1422],0,0,1150)
    {
    FName = "stn4"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([936,1314],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([936,1494],0,0,-1)
    {
    Name = "Fault"
    }
   0.annotation([1044,1098],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.pgb([1620,1440],0,44963872,970)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1620,1476],0,44966784,880)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1746,1440],0,44969696,940)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1746,1476],0,44972608,820)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.datalabel([1422,1116],2,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1440,1098],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1458,1080],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([1476,1116],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([1638,1116],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1584,1116],2,0,-1)
    {
    Name = "I20"
    }
   0.datalabel([1620,1080],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([1602,1098],2,0,-1)
    {
    Name = "I2C"
    }
   0.datalabel([1782,1116],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1728,1116],2,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([1746,1098],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1764,1080],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1872,1116],2,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([1926,1116],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([1908,1080],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1890,1098],2,0,-1)
    {
    Name = "I4C"
    }
   0.tpflt([828,522],4,0,1400)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   .Prot_1([1872,684],0,0,770)
    {
    }
   .Prot_3([2052,684],0,0,750)
    {
    }
   .prot_2([1872,810],0,0,760)
    {
    }
   .Prot_4([2052,810],0,0,740)
    {
    }
   .Plots_B1([450,396],0,0,10)
    {
    }
   0.pgb([2016,1314],0,44993600,520)
    {
    Name = "V4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1620,1242],0,44996640,1270)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1494,1242],0,44999416,230)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   -Sticky-([1224,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 1224,1116,1332,1152
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.mux_array([1116,1332],0,0,1240)
    {
    DPath = "0"
    }
   0.var([1044,1116],0,45003616,130)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "1e-3"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   0.recorder2_0([828,1242],0,0,1340)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([432,1422],0,0,1210)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.const([144,1206],1,0,120)
    {
    Name = ""
    Value = "10.0"
    }
   0.const([198,1386],1,0,240)
    {
    Name = ""
    Value = "10.0"
    }
   0.const([612,1206],1,0,150)
    {
    Name = ""
    Value = "10.0"
    }
   0.const([612,1386],1,0,360)
    {
    Name = ""
    Value = "10.0"
    }
   -Wire-([270,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var([234,1278],0,45032448,170)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   -Wire-([702,1278],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([702,1566],0,0,-1)
    {
    Vertex="0,0;-396,0"
    }
   -Wire-([576,1530],0,0,-1)
    {
    Vertex="0,0;-486,0"
    }
   0.select([234,1422],6,0,340)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([90,1458],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.select([180,1242],6,0,580)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.var([54,1278],0,45039048,160)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   -Wire-([90,1278],0,0,-1)
    {
    Vertex="0,0;0,252"
    }
   -Wire-([90,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([216,1242],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([270,1422],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.select([648,1422],6,0,450)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.select([648,1242],6,0,180)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([576,1278],0,0,-1)
    {
    Vertex="0,0;0,252"
    }
   -Wire-([684,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([576,1458],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([576,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([234,1350],1,45047232,200)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([648,1170],1,45049952,140)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([648,1350],1,45052672,270)
    {
    Name = "en Record4"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([180,1170],1,45055392,110)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   .Controls([2034,504],4,0,600)
    {
    }
   -TLine-([576,522],0,43399448,-1)
    {
    Name = "LINE1"
    Date = 1144686327
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,44538016,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,468],0,44538864,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([522,198],0,49985688,-1)
      {
      Mode = "1"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,49986712,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -TLine-([576,738],0,43455200,-1)
    {
    Name = "LINE2"
    Date = 1144686328
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Tower_3_Delta([810,612],0,43456648,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "C:\\home\\user\\pscad\\lineconstants\\database\\acsr.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "C:\\home\\user\\pscad\\lineconstants\\database\\gw.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     0.Line_Ground([630,702],0,43484496,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([522,198],0,43484784,-1)
      {
      Mode = "1"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_FrePhase_Options([216,468],0,43485696,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     }
    }
   -Wire-([846,738],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([846,522],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Sticky-([1044,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 1044,504,1134,540
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   .Plots_B2([918,396],0,0,20)
    {
    }
   -Sticky-([18,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,36,594,252
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Description : 
- Two Thevinen Impedance sources connected via two parallel 100km transmission lines.  
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via two transmission lines.
- Six fault positions for full fault control ahead and behind station relays.
- Four breakers are independently timed controlled. (Default is closed) or operated using Breaker protection.
- Independent breaker pole tripping is possible.
 "
    }
   -Divider-([36,1008],0)
    {
    Size(2340,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1458,36],0)
    {
    Size(0,972)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Wire-([522,738],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.multimeter([504,522],0,0,30)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([504,738],0,0,70)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([864,522],4,0,40)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([864,738],4,0,100)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([2340,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2340,1242],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([2340,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2340,1278],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([2340,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2340,1314],0,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([2340,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2340,1350],0,0,-1)
    {
    Name = "V4rms"
    }
   -Sticky-([702,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 702,36,1098,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   }
  }
 }

